require("dotenv").config();
const express = require("express");
const cors = require("cors");
const fs = require("fs");
const path = require("path");
const https = require("https");
const enquiryRouter = require("./api/router");


const app = express();

app.use(express.json());

const options = {
  cert: fs.readFileSync(path.resolve(__dirname, 'nailstudio.crt')),
  key: fs.readFileSync(path.resolve(__dirname, 'nailstudio.key')),
};

let corsOptions = {};

if (process.env.NODE_ENV === "production") {
  corsOptions = {
    origin: "https://ftvnailstudio.in",
    // origin: "http://localhost:3030/",
    methods: "GET,POST",
    credentials: true,
  };
} else {
  corsOptions = {
    origin: "*",
  };
}
app.use(cors(corsOptions));

app.use("/api/enquiry", enquiryRouter);

const PORT = 3602;

const server = https.createServer(options, app);

server.listen(PORT, () => {
  console.log(`Server is listening at port ${PORT}`);
});
// app.listen(PORT, () => {
//   console.log(`server is listning at  post ${PORT}`);
// });

app.get("/", (req, res) => {
  res.send("Welcome to the node project");
});
